local SGPlayerCommon = require "stategraphs.sg_player_common"
local SGCommon = require "stategraphs.sg_common"
local fmodtable = require "defs.sound.fmodtable"
local PlayerSkillState = require "playerskillstate"
local soundutil = require "util.soundutil"
local fmodtable = require "defs.sound.fmodtable"
local combatutil = require "util.combatutil"

local events = {}

local HURTBOX_PRE_SIZE_MULT = 2 -- For a few frames in the startup, make hurtbox bigger to punish poor timing.

local HURTBOX_ATTACKING_SIZE_MULT = 2.8
local HURTBOX_ATTACKING_SIZE_FOCUS_MULT = 3 -- make sure it's bigger than the attack's hitbox, so if an enemy is attacking and we're diving in carelessly, we'll trade.

local HURTBOX_SIZE_FOCUS_PUNISHFRAME_MULT = 2.95

local attack_data =
{
	-- These are split out mainly because of the hitflags + fx offset.
	HIGH =
	{
		HITFLAGS = Attack.HitFlags.AIR_HIGH,
		DAMAGE = 2,
		DAMAGE_FOCUS = 4,
		HITSTUN = 2,
		PUSHBACK = 0.5,
		HITSTOP = HitStopLevel.MEDIUM,
		COMBAT_FN = "DoKnockbackAttack",
		HIT_FX = "hits_player_skill",
		HIT_FX_OFFSET_Y = 4,
	},
	MID =
	{
		HITFLAGS = Attack.HitFlags.DEFAULT,
		DAMAGE = 2,
		DAMAGE_FOCUS = 4,
		HITSTUN = 2,
		PUSHBACK = 0.5,
		HITSTOP = HitStopLevel.MEDIUM,
		COMBAT_FN = "DoKnockbackAttack",
		HIT_FX = "hits_player_skill",
		HIT_FX_OFFSET_Y = 2,
	},

	-- Only for fully charged focus attack.
	AOE =
	{
		HITFLAGS = Attack.HitFlags.GROUND,
		DAMAGE = 4,
		HITSTUN = 0,
		PUSHBACK = 0,
		HITSTOP = HitStopLevel.LIGHT,
		COMBAT_FN = "DoBasicAttack",
		HIT_FX = "hits_fire",
		HIT_FX_OFFSET_Y = 1.5,
	},
}

local function OnBodyHitBoxTriggered(inst, data)

	local attack = attack_data[inst.sg.statemem.attack]
	local focushit = inst.sg.statemem.focus

	local damage_mod = focushit and attack.DAMAGE_FOCUS or attack.DAMAGE

	local hit = SGCommon.Events.OnHitboxTriggered(inst, data, {
		attack_id = "skill",
		damage_mod = damage_mod,
		hitstoplevel = attack.HITSTOP,
		pushback = attack.PUSHBACK,
		focus_attack = focushit,
		hitflags = attack.HITFLAGS,
		combat_attack_fn = attack.COMBAT_FN,
		hit_fx = attack.HIT_FX,
		disable_self_hitstop = true,
		hit_fx_offset_y = attack.HIT_FX_OFFSET_Y,
		set_dir_angle_to_target = true,
	})

	if hit then
		inst:PushEvent("skill_hit")
	end
end

local function OnAOEHitBoxTriggered(inst, data)
	local attack = attack_data.AOE

	local hit = SGCommon.Events.OnHitboxTriggered(inst, data, {
		attack_id = "skill",
		damage_mod = attack.DAMAGE,
		hitstoplevel = attack.HITSTOP,
		pushback = attack.PUSHBACK,
		focus_attack = true,
		hitflags = attack.HITFLAGS,
		combat_attack_fn = attack.COMBAT_FN,
		hit_fx = attack.HIT_FX,
		-- hit_fx_offset_x = 0,
		disable_self_hitstop = true,
		hit_fx_offset_y = attack.HIT_FX_OFFSET_Y,
		set_dir_angle_to_target = true,
	})

	if hit then
		inst:PushEvent("skill_hit")
	end
end

local function OpenCannonQuickRiseWindow(inst)
	-- For Cannon:
	if inst.sg.statemem.queued_cannonheavy then
		-- If they have pressed H before this being called, then go into the quickrise.
		if inst.sg.mem.ammo > 0 then
			inst.sg:GoToState("cannon_quickrise")
		else
			inst.sg:GoToState("cannon_quickrise_noammo")
		end
	else
		-- If they haven't, then open up the gate so they /can/ quickrise from here on out.
		inst.sg.statemem.cancannonheavy = true
	end
end

local function HandleCannonQuickRise(inst, data)
	-- Only for Cannon
	if inst.sg.mem.heavydodge and data.control == "heavyattack" then

		-- If they've already passed the "can do the cancel" moment, do so.
		if inst.sg.statemem.cancannonheavy then
			-- A bit of a hack, if we add another heavydodge we'll have to add support here.
			if inst.sg.mem.ammo > 0 then
				inst.sg:GoToState("cannon_quickrise", false)
			else
				inst.sg:GoToState("cannon_quickrise_noammo", false)
			end

		-- Otherwise, they are pressing it slightly early, so queue it up.
		-- Once we hit the "can do the cancel" moment, we'll check this bool and to the transition if needed.
		else
			inst.sg.statemem.queued_cannonheavy = true
		end
	else
		-- Not cannon! Return true to fallthrough to the normal controlevent flow
		return true
	end
end

local states =
{
	PlayerSkillState({
		name = "skill_miniboss_floracrane",
		tags = { "busy", "attack" },
		onenter = function(inst)
			inst.AnimState:PlayAnimation("skill_flora_dive_pre")
			if not inst.components.playercontroller:IsControlHeld("skill") then
				inst.sg.statemem.mustexit = true
			end

			-- sound cleanup
			inst.sg.mem.roar_sound = nil

			-- For the start of this attack, make hurtbox bigger to punish risky timing.
			inst.sg.statemem.hitboxsize = inst.HitBox:GetSize()
			inst.HitBox:SetNonPhysicsRect(inst.sg.statemem.hitboxsize * HURTBOX_PRE_SIZE_MULT)
		end,

		timeline =
		{
			FrameEvent(3, function(inst) inst.sg.mem.jump_sound = soundutil.PlayCodeSound(inst, fmodtable.Event.Skill_Floracrane_Jump,{ max_count = 1 }) end),
			FrameEvent(3, function(inst)
				-- this used to be Skill_Floracrane_Charge_LP but we're not reaaaally looping for very long here and it was causing issues
				-- so I don't assign a handle to it anymore and instead just fire a one-shot. Code for exiting the loop does still exist for later
				soundutil.PlayCodeSound(inst, fmodtable.Event.Skill_Floracrane_Charge,
				{
					max_count = 1,
					is_autostop = true,
					stopatexitstate = true,
					fmodparams = {
						skill_chargeLevel = 0,
					}
				})
			end),
			FrameEvent(5, function(inst)
				inst.sg:AddStateTag("airborne")
				inst.Physics:StartPassingThroughObjects()
				inst.sg.mem.roar_sound = soundutil.PlayCodeSound(inst, fmodtable.Event.Skill_Floracrane_Jump_Roar)
			end),
			FrameEvent(8, function(inst)
				inst.sg:AddStateTag("airborne_high") -- add one frame late, otherwise this is way too powerful
			end),
		},

		onupdate = function(inst)
			if not inst.components.playercontroller:IsControlHeld("skill") then
				if inst.sg.statemem.canexit then
					inst.sg:GoToState("skill_miniboss_floracrane_dive", false)
				end
				inst.sg.statemem.mustexit = true
			end
		end,

		onexit = function(inst)
			SGPlayerCommon.Fns.SafeStopPassingThroughObjects(inst)
			inst.HitBox:SetNonPhysicsRect(inst.sg.statemem.hitboxsize)

			if inst.sg.mem.roar_sound then
				soundutil.KillSound(inst, inst.sg.mem.roar_sound)
				inst.sg.mem.roar_sound = nil
			end

			if inst.sg.mem.charge_lp_sound then
				soundutil.KillSound(inst, inst.sg.mem.charge_lp_sound)
				inst.sg.mem.charge_lp_sound = nil
			end
		end,

		events =
		{
			EventHandler("controlupevent", function(inst, data)
				if data.control == "skill" then
					if inst.sg.statemem.canexit then
						-- This is after frame 10, so let's exit now
						inst.sg:GoToState("skill_miniboss_floracrane_dive", false)
					else
						-- If the player has released SKILL before frame 15, then set a flag so that once we hit frame 15 we MUST exit.
						inst.sg.statemem.mustexit = true
					end
				end
			end),
			EventHandler("animover", function(inst)
				if inst.sg.statemem.mustexit then
					inst.sg:GoToState("skill_miniboss_floracrane_dive", false)
				else
					if inst.sg.mem.charge_lp_sound then
						soundutil.SetInstanceParameter(inst, inst.sg.mem.charge_lp_sound, "skill_chargeLevel", 1)
					end
					inst.sg:GoToState("skill_miniboss_floracrane_hold")
				end
			end),
		},
	}),

	PlayerSkillState({
		name = "skill_miniboss_floracrane_hold",
		tags = { "busy", "airborne", "airborne_high" },

		onenter = function(inst, loops)
			inst.AnimState:PlayAnimation("skill_flora_dive_hold")
			if inst.sg.mem.roar_sound then
				soundutil.SetInstanceParameter(inst, inst.sg.mem.roar_sound, "skill_chargeLevel", 1)
				inst.sg.mem.roar_sound = nil -- stop tracking
			end
		end,

		timeline =
		{
			FrameEvent(1, function(inst)
				soundutil.PlayCodeSound(inst, fmodtable.Event.Skill_Floracrane_Charged,
				{
					max_count = 1,
				})
			end),
		},

		onupdate = function(inst)
			if not inst.components.playercontroller:IsControlHeld("skill") then
				inst.sg:GoToState("skill_miniboss_floracrane_dive", false)
			end
		end,

		events =
		{
			EventHandler("animover", function(inst)
				if not inst.components.playercontroller:IsControlHeld("skill") then
					inst.sg:GoToState("skill_miniboss_floracrane_dive")
				else
					inst.sg:GoToState("skill_miniboss_floracrane_dive_focus")
				end
			end),
		},
	}),

	PlayerSkillState({
		name = "skill_miniboss_floracrane_dive",
		tags = { "busy", "airborne", "airborne_high", "attack" },
		onenter = function(inst)

			--NORMAL ATTACK, not focus attack.

			inst.AnimState:PlayAnimation("skill_flora_dive")
			SGCommon.Fns.SetMotorVelScaled(inst, 50)
			inst.Physics:StartPassingThroughObjects()
			inst.components.hitbox:StartRepeatTargetDelay()

			inst.sg.statemem.focus = false

			--sound
			if inst.sg.mem.jump_sound then
				soundutil.KillSound(inst, inst.sg.mem.jump_sound)
				inst.sg.mem.jump_sound = nil
			end

			if inst.sg.mem.charge_lp_sound then
				soundutil.KillSound(inst, inst.sg.mem.charge_lp_sound)
				inst.sg.mem.charge_lp_sound = nil
			end

			inst.sg.statemem.hitboxsize = inst.HitBox:GetSize()
			inst.HitBox:SetNonPhysicsRect(inst.sg.statemem.hitboxsize * HURTBOX_ATTACKING_SIZE_MULT)

			soundutil.PlayCodeSound(inst, fmodtable.Event.Skill_Floracrane_Dive,{
				max_count = 1,
				stopatexitstate = true
			})
			
		end,

		timeline =
		{
			FrameEvent(2, function(inst)
				inst.sg:RemoveStateTag("airborne_high")
				inst.sg:RemoveStateTag("airborne")
			end),
			FrameEvent(3, function(inst)
				inst.Physics:Stop()
				SGPlayerCommon.Fns.SafeStopPassingThroughObjects(inst)
				soundutil.PlayCodeSound(inst, fmodtable.Event.Skill_Floracrane_Impact,{
					max_count = 1,
				})
			end),

			FrameEvent(0, function(inst) inst.sg.statemem.attack = "HIGH" end),

			FrameEvent(0, function(inst)
				combatutil.StartMeleeAttack(inst)
				inst.components.hitbox:PushBeam(0, 1.5, 1.5, HitPriority.PLAYER_DEFAULT)
			end),
			FrameEvent(1, function(inst) inst.components.hitbox:PushBeam(0, 1.5, 1.5, HitPriority.PLAYER_DEFAULT) end),

			FrameEvent(2, function(inst) inst.sg.statemem.attack = "MID" end),
			FrameEvent(2, function(inst) inst.components.hitbox:PushBeam(-2, 1.5, 1.5, HitPriority.PLAYER_DEFAULT) end),
			FrameEvent(3, function(inst) inst.components.hitbox:PushBeam(-2, 1.5, 1.5, HitPriority.PLAYER_DEFAULT) end),
			FrameEvent(4, function(inst)
				inst.components.hitbox:PushBeam(-2, 1.5, 1.5, HitPriority.PLAYER_DEFAULT)
				combatutil.EndMeleeAttack(inst)
			end),

			FrameEvent(6, SGPlayerCommon.Fns.SetCanDodge),
			FrameEvent(6, OpenCannonQuickRiseWindow),
		},

		onexit = function(inst)
			SGPlayerCommon.Fns.SafeStopPassingThroughObjects(inst)
			inst.components.hitbox:StopRepeatTargetDelay()
			inst.HitBox:SetNonPhysicsRect(inst.sg.statemem.hitboxsize)
		end,

		events =
		{
			EventHandler("hitboxtriggered", OnBodyHitBoxTriggered),

			EventHandler("animover", function(inst)
				inst.sg:GoToState("skill_miniboss_floracrane_dive_pst", inst.sg.statemem.focus)
			end),

			EventHandler("controlevent", HandleCannonQuickRise),
		},
	}),


	PlayerSkillState({
		name = "skill_miniboss_floracrane_dive_focus",
		tags = { "busy", "airborne", "airborne_high", "attack" },
		onenter = function(inst)
			inst.AnimState:PlayAnimation("skill_flora_dive")
			SGCommon.Fns.SetMotorVelScaled(inst, 50)
			inst.Physics:StartPassingThroughObjects()
			inst.components.hitbox:StartRepeatTargetDelay()

			inst.sg.statemem.hitboxfn = OnBodyHitBoxTriggered

			inst.sg.statemem.focus = true

			inst.sg.statemem.hitboxsize = inst.HitBox:GetSize()
			inst.HitBox:SetNonPhysicsRect(inst.sg.statemem.hitboxsize * HURTBOX_ATTACKING_SIZE_FOCUS_MULT)

			-- sound
			if inst.sg.mem.jump_sound then
				soundutil.KillSound(inst, inst.sg.mem.jump_sound)
				inst.sg.mem.jump_sound = nil
			end

			if inst.sg.mem.charge_lp_sound then
				soundutil.KillSound(inst, inst.sg.mem.charge_lp_sound)
				inst.sg.mem.charge_lp_sound = nil
			end

			inst.components.playercontroller:OverrideControlQueueTicks("dodge", 10 * ANIM_FRAMES)

			soundutil.PlayCodeSound(inst, fmodtable.Event.Skill_Floracrane_Dive, {
				max_count = 1,
				stopatexitstate = true,
				fmodparams = {
					isFocusAttack = 1 or 0,
				}
			})
		end,

		timeline =
		{
			FrameEvent(2, function(inst)
				inst.sg:RemoveStateTag("airborne_high")
				inst.sg:RemoveStateTag("airborne")
			end),

			FrameEvent(3, function(inst)
				inst.Physics:Stop()
				SGPlayerCommon.Fns.SafeStopPassingThroughObjects(inst)
				soundutil.PlayCodeSound(inst, fmodtable.Event.Skill_Floracrane_Impact,
					{
						max_count = 1,
						fmodparams =
						{
							isFocusAttack = 1 or 0,
						}
					})
			end),

			FrameEvent(0, function(inst)
				inst.sg.statemem.attack = "HIGH"
				combatutil.StartMeleeAttack(inst)
			end),
			FrameEvent(0, function(inst) inst.components.hitbox:PushBeam(0, 1.5, 1.5, HitPriority.PLAYER_DEFAULT) end),
			FrameEvent(1, function(inst) inst.components.hitbox:PushBeam(0, 1.5, 1.5, HitPriority.PLAYER_DEFAULT) end),

			FrameEvent(2, function(inst) inst.sg.statemem.attack = "MID" end),
			FrameEvent(2, function(inst) inst.components.hitbox:PushBeam(-2, 1.5, 1.5, HitPriority.PLAYER_DEFAULT) end),
			FrameEvent(3, function(inst) inst.components.hitbox:PushBeam(-2, 1.5, 1.5, HitPriority.PLAYER_DEFAULT) end),

			-- Don't do another target delay for this time -- if they hit the thing while airborne, they shouldn't hit it again from the AoE splash.
			FrameEvent(5, function(inst)
				-- Bigger hurtbox on landing
				inst.HitBox:SetNonPhysicsRect(inst.sg.statemem.hitboxsize * HURTBOX_SIZE_FOCUS_PUNISHFRAME_MULT)

				inst.sg.statemem.hitboxfn = OnAOEHitBoxTriggered
				inst.sg.statemem.attack = "AOE"
				inst.components.hitbox:PushCircle(0, 0, 3, HitPriority.PLAYER_DEFAULT)
			end),

			FrameEvent(6, function(inst)
				inst.components.hitbox:PushCircle(0, 0, 4, HitPriority.PLAYER_DEFAULT)
				combatutil.EndMeleeAttack(inst)
			end),

			-- cancels
			FrameEvent(8, SGPlayerCommon.Fns.SetCanDodge),
			FrameEvent(8, OpenCannonQuickRiseWindow),
		},

		onexit = function(inst)
			SGPlayerCommon.Fns.SafeStopPassingThroughObjects(inst)
			inst.components.hitbox:StopRepeatTargetDelay()
			inst.HitBox:SetNonPhysicsRect(inst.sg.statemem.hitboxsize)
		end,

		events =
		{
			EventHandler("hitboxtriggered", function(inst, data) inst.sg.statemem.hitboxfn(inst, data) end),

			EventHandler("animover", function(inst)
				inst.sg:GoToState("skill_miniboss_floracrane_dive_pst", true)
			end),
			EventHandler("controlevent", HandleCannonQuickRise),
		},
	}),

	PlayerSkillState({
		name = "skill_miniboss_floracrane_dive_pst",
		tags = { "busy", "attack" },
		onenter = function(inst, focus)
			inst.AnimState:PlayAnimation("skill_flora_dive_pst")
			inst.sg.statemem.focus = focus

			inst.sg.statemem.hitboxsize = inst.HitBox:GetSize()
			if focus then
				inst.HitBox:SetNonPhysicsRect(inst.sg.statemem.hitboxsize * HURTBOX_ATTACKING_SIZE_FOCUS_MULT)
			else
				inst.HitBox:SetNonPhysicsRect(inst.sg.statemem.hitboxsize * HURTBOX_ATTACKING_SIZE_MULT)
			end

			SGPlayerCommon.Fns.SetCanDodge(inst)
			OpenCannonQuickRiseWindow(inst)
		end,

		timeline =
		{
			FrameEvent(15, SGPlayerCommon.Fns.RemoveBusyState),
		},

		onexit = function(inst)
			inst.HitBox:SetNonPhysicsRect(inst.sg.statemem.hitboxsize)
		end,

		events =
		{
			EventHandler("animover", function(inst)
				inst.sg:GoToState("skill_pst")
			end),

			EventHandler("controlevent", HandleCannonQuickRise),
		},
	}),
}

return StateGraph("sg_player_skill_miniboss_floracrane", states, events, "skill_miniboss_floracrane")
